package gov.va.med.mhv.sm.api.transfer;

import gov.va.med.mhv.sm.api.util.ClientApplicationHelper;
import gov.va.med.mhv.sm.enumeration.UserTypeEnum;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.User;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;

import org.apache.http.client.utils.DateUtils;


import org.hibernate.TypeMismatchException;

public class Session implements Serializable {
	private static final long serialVersionUID = -5454873976482094676L;

	private long userId;
	private Date timestamp;
	private UserTypeEnum userTypeEnum;
	private transient User user;
	private ClientApplication clientApplication;
	private int expirationSeconds = 300; //Default to 5 minutes

	public Session(long userId, ClientApplication clientApplication, UserTypeEnum userTypeEnum) {
		this.userId = userId;
		this.clientApplication = clientApplication;
		this.expirationSeconds = clientApplication.getTimeoutSeconds().intValue();
		this.userTypeEnum = userTypeEnum;
		touch();
	}

	private Session(long userId, ClientApplication clientApplication, Date timestamp, UserTypeEnum userTypeEnum) {
		this.userId = userId;
		this.clientApplication = clientApplication;
		this.expirationSeconds = clientApplication.getTimeoutSeconds().intValue();
		this.userTypeEnum = userTypeEnum;
		this.timestamp = timestamp;
	}

	public long getUserId() {
		return userId;
	}
	public void setUserId(long userId) {
		this.userId = userId;
	}
	public Date getTimestamp() {
		return timestamp;
	}
	public void setTimestamp(Date timestamp) {
		this.timestamp = timestamp;
	}
	public long getExpirationSeconds() {
		return expirationSeconds;
	}
	public void setExpirationSeconds(int expirationSeconds) {
		this.expirationSeconds = expirationSeconds;
	}
	public User getUser() {
		return user;
	}
	public void setUser(User user) {
		this.user = user;
	}
	public Patient getPatient() {
		if( !(user instanceof Patient) ){
			throw new TypeMismatchException("User is not a Patient");
		}
		return (Patient) user;
	}
	public Clinician getClinician() {
		if( !(user instanceof Clinician) ){
			throw new TypeMismatchException("User is not a Clinician");
		}
		return (Clinician) user;
	}
	public boolean isPatient() {
		return (user instanceof Patient);
	}
	public boolean isClinician() {
		return (user instanceof Clinician);
	}
	public ClientApplication getClientApplication() {
		return clientApplication;
	}
	public void setClientApplication(ClientApplication clientApplication) {
		this.clientApplication = clientApplication;
	}
	public String getFormattedTimestamp() {
		Date expiresDate = timestamp;
		return DateUtils.formatDate(expiresDate);
	}
	public UserTypeEnum getUserTypeEnum() {
		return userTypeEnum;
	}
	public void setUserTypeEnum(UserTypeEnum userTypeEnum) {
		this.userTypeEnum = userTypeEnum;
	}

	public void touch() {
		this.timestamp = new Date(System.currentTimeMillis() + (getExpirationSeconds() * 1000));
	}

	public boolean isExpired() {
		long currentTimeinSec = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
		long timeSeconds = TimeUnit.MILLISECONDS.toSeconds(timestamp.getTime());
		if ((currentTimeinSec - timeSeconds) <= (getExpirationSeconds()) ) {
			return false;
		} else {
			return true;
		}
	}

	public byte[] marshall() throws IOException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		baos.write(String.valueOf(getUserId()).getBytes());
		baos.write("|".getBytes());
		baos.write(String.valueOf(getClientApplication().getId()).getBytes());
		baos.write("|".getBytes());
		baos.write(String.valueOf(getTimestamp().getTime()).getBytes());
		baos.write("|".getBytes());
		baos.write(String.valueOf(userTypeEnum.getId().longValue()).getBytes());

		return baos.toByteArray();
	}
	public static Session unmarshall(byte[] bytes) throws IOException,
			ClassNotFoundException {
		String sessionStr = new String(bytes);
		StringTokenizer st = new StringTokenizer(sessionStr,"|");
		if( st.countTokens() == 4 ) {
			try {
				return new Session(Long.parseLong(st.nextToken()),ClientApplicationHelper.findClientApplication(Long.parseLong(st.nextToken())), new Date(Long.parseLong(st.nextToken())), UserTypeEnum.valueOf(Long.parseLong(st.nextToken()) ));
			} catch (Exception e) {
				throw new IOException("Unable to unmarshall object");
			}
		} else {
			throw new IOException("Unable to unmarshall object");
		}
	}

	public String toString() {
		return "Session {userId: " + userId + ";expirationTimestamp: " + timestamp + "; User: " + user + ";ClientApplication: " + clientApplication + ";userTypeEnum: " + userTypeEnum + "}";
	}

}
